var collision = {
    check: {
        rec_rec: function(rect1, rect2) {
            return rect1.pos.x < rect2.pos.x + rect2.width
                && rect1.pos.x + rect1.width > rect2.pos.x
                && rect1.pos.y < rect2.pos.y + rect2.height
                && rect1.pos.y + rect1.height > rect2.pos.y
        },
        cir_cir: function(circle1, circle2) {
            var dx = circle1.pos.x - circle2.pos.x
            var dy = circle1.pos.y - circle2.pos.y
            var distance = Math.sqrt(dx * dx + dy * dy)
            return distance <= circle1.radius + circle2.radius
        },
        rec_cir: function(rectangle, circle) {
            var distX = Math.abs(circle.pos.x - rectangle.pos.x - rectangle.width /  2)
            var distY = Math.abs(circle.pos.y - rectangle.pos.y - rectangle.height /  2)

            if (distX > (rectangle.width /  2 + circle.radius)) return false
            if (distY > (rectangle.height /  2 + circle.radius)) return false

            if (distX <= (rectangle.width /  2)) return true
            if (distY <= (rectangle.height /  2)) return true

            var dx = distX - rectangle.width /  2
            var dy = distY - rectangle.height /  2
            return (dx * dx + dy * dy <= (circle.radius * circle.radius))
        }
    }
}

export default collision